/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.common.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.duckling.common.constants.DuckVariant;
import tech.thatgravyboat.duckling.common.registry.ModEntities;
import tech.thatgravyboat.duckling.common.registry.ModItems;
import tech.thatgravyboat.duckling.common.registry.ModSounds;

public class DuckEntity
extends TamableAnimal
implements IAnimatable {
    public static final Ingredient BREEDING_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42406_});
    private static final EntityDataAccessor<DuckVariant> VARIANT = SynchedEntityData.m_135353_(DuckEntity.class, ModEntities.DUCK_VARIANT);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int eggLayTime = this.f_19796_.nextInt(6000) + 6000;

    public DuckEntity(EntityType<DuckEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createDuckAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 4.0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.m_21120_(hand);
        if (stackInHand.m_150930_(ModItems.HOLIDAY_FRUIT_CAKE.get()) && this.m_6084_() && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(1.0f);
            stackInHand.m_41774_(1);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        if (stackInHand.m_41619_() && this.m_6084_()) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(VARIANT, (Object)DuckVariant.PEKIN);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, BREEDING_INGREDIENT, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData initialize = super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
        this.m_20088_().m_135381_(VARIANT, (Object)(world.m_5822_().nextBoolean() ? DuckVariant.MALLARD : DuckVariant.PEKIN));
        return initialize;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return ModSounds.QUACK.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return ModSounds.DUCK_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.DUCK_DEATH.get();
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_20088_().m_135381_(VARIANT, (Object)DuckVariant.getVariant(nbt.m_128461_("Variant")));
        if (nbt.m_128441_("EggLayTime")) {
            this.eggLayTime = nbt.m_128451_("EggLayTime");
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Variant", ((DuckVariant)((Object)this.m_20088_().m_135370_(VARIANT))).name());
        nbt.m_128405_("EggLayTime", this.eggLayTime);
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3d = this.m_20184_();
        if (!this.f_19861_ && vec3d.f_82480_ < 0.0) {
            this.m_20256_(vec3d.m_82542_(1.0, 0.8, 1.0));
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_6162_() && --this.eggLayTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)ModItems.DUCK_EGG.get());
            this.eggLayTime = this.f_19796_.nextInt(6000) + 6000;
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        DuckEntity duckEntity = (DuckEntity)ModEntities.DUCK.get().m_20615_((Level)world);
        DuckVariant variant = null;
        if (entity instanceof DuckEntity) {
            DuckEntity duck = (DuckEntity)entity;
            if (duckEntity != null) {
                DuckVariant texture = this.getTexture();
                if (duck.getTexture() == texture && texture != DuckVariant.AGENTD) {
                    variant = texture;
                }
            }
        }
        if (duckEntity != null) {
            if (variant == null) {
                variant = world.f_46441_.nextBoolean() ? DuckVariant.PEKIN : DuckVariant.MALLARD;
            }
            duckEntity.m_20088_().m_135381_(VARIANT, variant);
        }
        return duckEntity;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6162_() ? dimensions.f_20378_ * 0.85f : dimensions.f_20378_ * 0.92f;
    }

    public DuckVariant getTexture() {
        return this.m_7755_().m_6111_().equalsIgnoreCase("agent d") ? DuckVariant.AGENTD : (DuckVariant)((Object)this.m_20088_().m_135370_(VARIANT));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        AnimationBuilder builder = new AnimationBuilder();
        if (this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_)) {
            builder.addAnimation("walking", Boolean.valueOf(true));
        } else if (!this.f_19861_) {
            builder.addAnimation("falling", Boolean.valueOf(true));
        } else if (event.isMoving()) {
            builder.addAnimation("walking", Boolean.valueOf(true));
        } else {
            builder.addAnimation("idle", Boolean.valueOf(true));
        }
        event.getController().setAnimation(builder);
        return PlayState.CONTINUE;
    }

    public boolean m_6898_(ItemStack stack) {
        return BREEDING_INGREDIENT.test(stack);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

